/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.world.World;

public class BlockEntityRenderDelegate {
    public static final BlockEntityRenderDelegate DISGUISED_BLOCK = new BlockEntityRenderDelegate();
    public static final BlockEntityRenderDelegate PROJECTOR = new BlockEntityRenderDelegate();
    private final Map<TileEntity, DelegateRendererInfo> renderDelegates = new HashMap<TileEntity, DelegateRendererInfo>();

    public static void putDisguisedTeRenderer(TileEntity disguisableTileEntity, ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        DISGUISED_BLOCK.putDelegateFor(disguisableTileEntity, NBTUtil.func_190008_d((NBTTagCompound)stack.func_77978_p().func_74775_l("SavedState")), stack);
    }

    public void putDelegateFor(TileEntity originalTileEntity, IBlockState delegateState, ItemStack stack) {
        DelegateRendererInfo delegateInfo;
        if (this.renderDelegates.containsKey(originalTileEntity) && (delegateInfo = this.renderDelegates.get(originalTileEntity)).delegateTileEntity.func_145838_q() == delegateState.func_177230_c()) {
            ((DelegateRendererInfo)delegateInfo).delegateTileEntity.field_145847_g = delegateState.func_177230_c().func_176201_c(delegateState);
            return;
        }
        if (delegateState != null && delegateState.func_177230_c().hasTileEntity(delegateState)) {
            Minecraft mc = Minecraft.func_71410_x();
            TileEntity delegateTe = delegateState.func_177230_c().createTileEntity((World)mc.field_71441_e, delegateState);
            delegateTe.field_145854_h = delegateState.func_177230_c();
            delegateTe.field_145847_g = delegateState.func_177230_c().func_176201_c(delegateState);
            delegateTe.func_145834_a((World)mc.field_71441_e);
            if (delegateTe instanceof TileEntityBanner) {
                ((TileEntityBanner)delegateTe).func_175112_a(stack, false);
            } else {
                Utils.updateBlockEntityWithItemTag(delegateTe, stack);
            }
            TileEntitySpecialRenderer delegateTeRenderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(delegateTe);
            if (delegateTeRenderer != null) {
                this.renderDelegates.put(originalTileEntity, new DelegateRendererInfo(delegateTe, delegateTeRenderer));
            }
        }
    }

    public void removeDelegateOf(TileEntity originalTileEntity) {
        this.renderDelegates.remove(originalTileEntity);
    }

    public boolean tryRenderDelegate(TileEntity originalTileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        DelegateRendererInfo delegateRendererInfo = this.renderDelegates.get(originalTileEntity);
        if (delegateRendererInfo != null) {
            delegateRendererInfo.delegateRenderer().func_192841_a(delegateRendererInfo.delegateTileEntity(), x, y, z, partialTicks, destroyStage, alpha);
            return true;
        }
        return false;
    }

    private static class DelegateRendererInfo {
        private final TileEntity delegateTileEntity;
        private final TileEntitySpecialRenderer delegateRenderer;

        public DelegateRendererInfo(TileEntity delegateTileEntity, TileEntitySpecialRenderer delegateRenderer) {
            this.delegateTileEntity = delegateTileEntity;
            this.delegateRenderer = delegateRenderer;
        }

        public TileEntity delegateTileEntity() {
            return this.delegateTileEntity;
        }

        public TileEntitySpecialRenderer delegateRenderer() {
            return this.delegateRenderer;
        }
    }
}

